﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Windows.Markup;

namespace Replikanto
{
	[MarkupExtensionReturnType(typeof(IEnumerable<LocalizedValue>))]
	public class EnumExtension : MarkupExtension
	{
		public EnumExtension()
		{
		}

		public EnumExtension(Type enumType)
		{
			this.EnumType = enumType;
		}

		[ConstructorArgument("enumType")]
		public Type EnumType { get; set; }

		public bool UseDisplayAttribute { get; set; }

		public override object ProvideValue(IServiceProvider serviceProvider)
		{
			if (Delegate88.smethod_0(this.EnumType, null, Delegate88.delegate88_0))
			{
				throw new InvalidOperationException("The enum type is not set");
			}
			if (!this.UseDisplayAttribute)
			{
				return Delegate89.smethod_0(this.EnumType, Delegate89.delegate89_0).Cast<Enum>().Select(new Func<Enum, LocalizedValue>(EnumExtension.<>c.<>c_0.method_0));
			}
			return LocalizationUtilities.GetEnumLocalization(this.EnumType);
		}

		internal static void smethod_0()
		{
		}

		internal static void smethod_1()
		{
		}

		internal static object smethod_2(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static object smethod_3(Type type)
		{
			return LocalizationUtilities.GetEnumLocalization(type);
		}

		internal static void smethod_4()
		{
		}

		[CompilerGenerated]
		private Type type_0;

		[CompilerGenerated]
		private bool bool_0;
	}
}
