﻿using System;
using System.Runtime.CompilerServices;

namespace Replikanto
{
	public class CompositeID : IEquatable<CompositeID>
	{
		public static CompositeID Empty()
		{
			return new CompositeID
			{
				Id = -1L
			};
		}

		public long Id { get; set; }

		public string Name { get; set; }

		public override string ToString()
		{
			return Delegate82.smethod_0("{0},{1}", this.Id, this.Name, Delegate82.delegate82_0);
		}

		public static CompositeID Create(string str)
		{
			CompositeID compositeID;
			try
			{
				string[] array = Delegate191.smethod_0(str, new char[] { ',' }, Delegate191.delegate191_0);
				compositeID = new CompositeID
				{
					Id = Delegate98.smethod_0(array[0], Delegate98.delegate98_0),
					Name = array[1]
				};
			}
			catch
			{
				compositeID = null;
			}
			return compositeID;
		}

		public override int GetHashCode()
		{
			int num = 13;
			if (this.Id != 0L)
			{
				int num2 = num * 7;
				long id = this.Id;
				num = num2 + Delegate173.smethod_0(ref id, Delegate173.delegate173_0);
			}
			if (this.Name != null)
			{
				num = num * 7 + Delegate192.smethod_0(this.Name, Delegate192.delegate192_0);
			}
			return num;
		}

		public bool Equals(CompositeID other)
		{
			return other != null && this.Id == other.Id && Delegate102.smethod_0(this.Name, other.Name, Delegate102.delegate102_0);
		}

		public override bool Equals(object obj)
		{
			return obj != null && this.Id == ((CompositeID)obj).Id && Delegate102.smethod_0(this.Name, ((CompositeID)obj).Name, Delegate102.delegate102_0);
		}

		public static bool IsEmpty(CompositeID obj)
		{
			return obj == null || obj.Id == -1L;
		}

		internal static object smethod_0(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static void smethod_1(object object_0, long value)
		{
			object_0.Id = value;
		}

		internal static void smethod_2(object object_0, object object_1)
		{
			object_0.Name = object_1;
		}

		internal static long smethod_3(object object_0)
		{
			return object_0.Id;
		}

		internal static object smethod_4(object object_0)
		{
			return object_0.Name;
		}

		internal static void smethod_5()
		{
		}

		internal static void smethod_6()
		{
		}

		[CompilerGenerated]
		private long long_0;

		[CompilerGenerated]
		private string string_0;
	}
}
