﻿using System;
using System.Diagnostics;
using System.IO;
using System.Linq.Expressions;
using System.Net;
using System.Runtime.CompilerServices;
using System.Security.Principal;
using System.Threading;
using Microsoft.CSharp.RuntimeBinder;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using NinjaTrader.Cbi;
using NinjaTrader.NinjaScript.AddOns.FlowBots;
using Replikanto.Properties;

namespace Replikanto.Communicator
{
	public class NetworkBroker
	{
		internal event Action<string, ReplikantoAccount, ReplikantoOrder> MessageReceived
		{
			[CompilerGenerated]
			add
			{
				Action<string, ReplikantoAccount, ReplikantoOrder> action = this.action_0;
				Action<string, ReplikantoAccount, ReplikantoOrder> action2;
				do
				{
					action2 = action;
					Action<string, ReplikantoAccount, ReplikantoOrder> action3 = (Action<string, ReplikantoAccount, ReplikantoOrder>)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action<string, ReplikantoAccount, ReplikantoOrder>>(ref this.action_0, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action<string, ReplikantoAccount, ReplikantoOrder> action = this.action_0;
				Action<string, ReplikantoAccount, ReplikantoOrder> action2;
				do
				{
					action2 = action;
					Action<string, ReplikantoAccount, ReplikantoOrder> action3 = (Action<string, ReplikantoAccount, ReplikantoOrder>)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action<string, ReplikantoAccount, ReplikantoOrder>>(ref this.action_0, action3, action2);
				}
				while (action != action2);
			}
		}

		internal event Action<string, ReplikantoAccount, Instrument, Instrument> InstrumentReceived
		{
			[CompilerGenerated]
			add
			{
				Action<string, ReplikantoAccount, Instrument, Instrument> action = this.action_1;
				Action<string, ReplikantoAccount, Instrument, Instrument> action2;
				do
				{
					action2 = action;
					Action<string, ReplikantoAccount, Instrument, Instrument> action3 = (Action<string, ReplikantoAccount, Instrument, Instrument>)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action<string, ReplikantoAccount, Instrument, Instrument>>(ref this.action_1, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action<string, ReplikantoAccount, Instrument, Instrument> action = this.action_1;
				Action<string, ReplikantoAccount, Instrument, Instrument> action2;
				do
				{
					action2 = action;
					Action<string, ReplikantoAccount, Instrument, Instrument> action3 = (Action<string, ReplikantoAccount, Instrument, Instrument>)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action<string, ReplikantoAccount, Instrument, Instrument>>(ref this.action_1, action3, action2);
				}
				while (action != action2);
			}
		}

		internal event Action OnStart
		{
			[CompilerGenerated]
			add
			{
				Action action = this.action_2;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_2, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action action = this.action_2;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_2, action3, action2);
				}
				while (action != action2);
			}
		}

		internal event Action OnStop
		{
			[CompilerGenerated]
			add
			{
				Action action = this.action_3;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_3, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action action = this.action_3;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_3, action3, action2);
				}
				while (action != action2);
			}
		}

		public NetworkBroker()
		{
			this.string_0 = "+";
			this.string_1 = "replikanto_node";
			this.version_0 = Delegate48.smethod_0(Delegate47.smethod_0(Delegate248.smethod_0(Delegate248.delegate248_0), Delegate47.delegate47_0), Delegate48.delegate48_0);
			if (!Delegate595.smethod_0(Delegate595.delegate595_0))
			{
				throw new Exception("HttpListener is not supported by your system's operation. Please contact the FlowBots support");
			}
		}

		public NetworkBroker(string server, string path)
			: this()
		{
			this.string_0 = server;
			this.string_1 = path;
		}

		public NetworkBroker(uint port)
			: this()
		{
			this.Port = port;
		}

		protected override void Finalize()
		{
			try
			{
				this.method_1();
			}
			finally
			{
				Delegate196.smethod_0(this, Delegate196.delegate196_0);
			}
		}

		public uint Port { get; set; }

		public bool? IsListening
		{
			get
			{
				HttpListener httpListener = this.httpListener_0;
				if (httpListener == null)
				{
					return null;
				}
				return new bool?(Delegate596.smethod_0(httpListener, Delegate596.delegate596_0));
			}
		}

		internal void Start()
		{
			if (this.httpListener_0 == null)
			{
				if (this.Port == 0U)
				{
					throw new Exception("Invalid port");
				}
				string text = Delegate50.smethod_0("http://{0}:{1}/{2}/", this.string_0, this.Port, this.string_1, Delegate50.delegate50_0);
				try
				{
					this.httpListener_0 = new HttpListener();
					Delegate598.smethod_0(Delegate597.smethod_0(this.httpListener_0, Delegate597.delegate597_0), text, Delegate598.delegate598_0);
					Delegate599.smethod_0(this.httpListener_0, Delegate599.delegate599_0);
					if (Delegate600.smethod_0(this.httpListener_0, Delegate600.delegate600_0))
					{
						Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: The server is listening on port {0}", this.Port, Delegate32.delegate32_0), 1, Delegate34.delegate34_0);
					}
					Action action = this.action_2;
					if (action != null)
					{
						action();
					}
					Delegate601.smethod_0(this.httpListener_0, new AsyncCallback(this.method_0), this.httpListener_0, Delegate601.delegate601_0);
				}
				catch (HttpListenerException ex)
				{
					if (Delegate602.smethod_0(ex, Delegate602.delegate602_0) == 5)
					{
						Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: ", Delegate31.smethod_0(ex, Delegate31.delegate31_0), Delegate33.delegate33_0), 2, Delegate34.delegate34_0);
						try
						{
							NTAccount ntaccount = Delegate603.smethod_0(new SecurityIdentifier(WellKnownSidType.WorldSid, null), Delegate45.smethod_0(typeof(NTAccount).TypeHandle, Delegate45.delegate45_0), Delegate603.delegate603_0) as NTAccount;
							string text2 = Delegate82.smethod_0("http add urlacl url={0} user=\"{1}\"", text, ntaccount, Delegate82.delegate82_0);
							Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: Trying to run> ", text2, Delegate33.delegate33_0), 1, Delegate34.delegate34_0);
							string text3 = Delegate55.smethod_0(text2, Array.Empty<object>(), Delegate55.delegate55_0);
							ProcessStartInfo processStartInfo = new ProcessStartInfo("netsh", text3);
							Delegate604.smethod_0(processStartInfo, "runas", Delegate604.delegate604_0);
							Delegate605.smethod_0(processStartInfo, true, Delegate605.delegate605_0);
							Delegate606.smethod_0(processStartInfo, ProcessWindowStyle.Hidden, Delegate606.delegate606_0);
							Delegate607.smethod_0(processStartInfo, true, Delegate607.delegate607_0);
							Delegate609.smethod_0(Delegate608.smethod_0(processStartInfo, Delegate608.delegate608_0), Delegate609.delegate609_0);
							this.method_1();
							this.Start();
							goto IL_0273;
						}
						catch (Exception ex2)
						{
							Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: ", Delegate31.smethod_0(ex2, Delegate31.delegate31_0), Delegate33.delegate33_0), 3, Delegate34.delegate34_0);
							throw new Exception("Error trying to run http command with admin privileges", ex2);
						}
						goto IL_0233;
						IL_0273:
						return;
					}
					IL_0233:
					Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: ", Delegate31.smethod_0(ex, Delegate31.delegate31_0), Delegate33.delegate33_0), 3, Delegate34.delegate34_0);
					try
					{
						this.method_1();
						goto IL_0270;
					}
					finally
					{
						throw new Exception("Error trying to start the http listener", ex);
					}
					goto IL_0270;
					for (;;)
					{
						IL_0270:
						goto IL_0270;
					}
				}
				catch (Exception ex3)
				{
					Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: ", Delegate31.smethod_0(ex3, Delegate31.delegate31_0), Delegate33.delegate33_0), 3, Delegate34.delegate34_0);
					throw new Exception("Error trying to start the http listener", ex3);
				}
			}
		}

		private void method_0(IAsyncResult iasyncResult_0)
		{
			JObject jobject = new JObject();
			HttpListenerContext httpListenerContext = null;
			try
			{
				HttpListener httpListener = (HttpListener)Delegate610.smethod_0(iasyncResult_0, Delegate610.delegate610_0);
				if (httpListener == null || !Delegate600.smethod_0(httpListener, Delegate600.delegate600_0))
				{
					return;
				}
				httpListenerContext = Delegate611.smethod_0(httpListener, iasyncResult_0, Delegate611.delegate611_0);
				HttpListenerRequest httpListenerRequest = Delegate612.smethod_0(httpListenerContext, Delegate612.delegate612_0);
				if (!Delegate102.smethod_0(Delegate613.smethod_0(httpListenerRequest, Delegate613.delegate613_0), "POST", Delegate102.delegate102_0))
				{
					jobject["version"] = Delegate86.smethod_0(Delegate48.smethod_0(Delegate47.smethod_0(Delegate248.smethod_0(Delegate248.delegate248_0), Delegate47.delegate47_0), Delegate48.delegate48_0), Delegate86.delegate86_0);
					jobject["msg"] = "Replikanto Http Listening Enabled";
				}
				else
				{
					try
					{
						if (!Delegate614.smethod_0(httpListenerRequest, Delegate614.delegate614_0))
						{
							jobject["status"] = false;
							jobject["msg"] = "No entity body";
						}
						else
						{
							Stream stream = Delegate615.smethod_0(httpListenerRequest, Delegate615.delegate615_0);
							try
							{
								StreamReader streamReader = new StreamReader(stream, Delegate616.smethod_0(httpListenerRequest, Delegate616.delegate616_0));
								try
								{
									JsonReader jsonReader = new JsonTextReader(streamReader);
									try
									{
										object obj = new JsonSerializer().Deserialize(jsonReader);
										string text = string.Empty;
										if (NetworkBroker.<>o__27.callSite_1 == null)
										{
											NetworkBroker.<>o__27.callSite_1 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
										}
										Func<CallSite, object, bool> target = NetworkBroker.<>o__27.callSite_1.Target;
										CallSite callSite_ = NetworkBroker.<>o__27.callSite_1;
										if (NetworkBroker.<>o__27.callSite_0 == null)
										{
											NetworkBroker.<>o__27.callSite_0 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ContainsKey", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
											{
												Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
												Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
											}, Delegate298.delegate298_0));
										}
										if (target(callSite_, NetworkBroker.<>o__27.callSite_0.Target(NetworkBroker.<>o__27.callSite_0, obj, "replikanto_id")))
										{
											try
											{
												if (NetworkBroker.<>o__27.callSite_3 == null)
												{
													NetworkBroker.<>o__27.callSite_3 = CallSite<Func<CallSite, object, string>>.Create(Delegate296.smethod_0(CSharpBinderFlags.ConvertExplicit, Delegate45.smethod_0(typeof(string).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
												}
												Func<CallSite, object, string> target2 = NetworkBroker.<>o__27.callSite_3.Target;
												CallSite callSite_2 = NetworkBroker.<>o__27.callSite_3;
												if (NetworkBroker.<>o__27.callSite_2 == null)
												{
													NetworkBroker.<>o__27.callSite_2 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
													{
														Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
														Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
													}, Delegate305.delegate305_0));
												}
												text = target2(callSite_2, NetworkBroker.<>o__27.callSite_2.Target(NetworkBroker.<>o__27.callSite_2, obj, "replikanto_id"));
											}
											catch
											{
											}
										}
										ReplikantoAccount replikantoAccount = null;
										if (NetworkBroker.<>o__27.callSite_5 == null)
										{
											NetworkBroker.<>o__27.callSite_5 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
										}
										Func<CallSite, object, bool> target3 = NetworkBroker.<>o__27.callSite_5.Target;
										CallSite callSite_3 = NetworkBroker.<>o__27.callSite_5;
										if (NetworkBroker.<>o__27.callSite_4 == null)
										{
											NetworkBroker.<>o__27.callSite_4 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ContainsKey", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
											{
												Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
												Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
											}, Delegate298.delegate298_0));
										}
										if (target3(callSite_3, NetworkBroker.<>o__27.callSite_4.Target(NetworkBroker.<>o__27.callSite_4, obj, "account")))
										{
											if (NetworkBroker.<>o__27.callSite_6 == null)
											{
												NetworkBroker.<>o__27.callSite_6 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
												{
													Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
													Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
												}, Delegate305.delegate305_0));
											}
											object obj2 = NetworkBroker.<>o__27.callSite_6.Target(NetworkBroker.<>o__27.callSite_6, obj, "account");
											if (NetworkBroker.<>o__27.callSite_8 == null)
											{
												NetworkBroker.<>o__27.callSite_8 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
											}
											Func<CallSite, object, bool> target4 = NetworkBroker.<>o__27.callSite_8.Target;
											CallSite callSite_4 = NetworkBroker.<>o__27.callSite_8;
											if (NetworkBroker.<>o__27.callSite_7 == null)
											{
												NetworkBroker.<>o__27.callSite_7 = CallSite<Func<CallSite, object, object, object>>.Create(Delegate302.smethod_0(CSharpBinderFlags.None, ExpressionType.NotEqual, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
												{
													Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
													Delegate297.smethod_0(CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
												}, Delegate302.delegate302_0));
											}
											if (target4(callSite_4, NetworkBroker.<>o__27.callSite_7.Target(NetworkBroker.<>o__27.callSite_7, obj2, null)))
											{
												try
												{
													if (NetworkBroker.<>o__27.callSite_9 == null)
													{
														NetworkBroker.<>o__27.callSite_9 = CallSite<Func<CallSite, object, ReplikantoAccount>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(ReplikantoAccount).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
													}
													Func<CallSite, object, ReplikantoAccount> target5 = NetworkBroker.<>o__27.callSite_9.Target;
													CallSite callSite_5 = NetworkBroker.<>o__27.callSite_9;
													if (NetworkBroker.<>o__27.yAvjYhdtGI == null)
													{
														NetworkBroker.<>o__27.yAvjYhdtGI = CallSite<Func<CallSite, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ToObject", new Type[] { Delegate45.smethod_0(typeof(ReplikantoAccount).TypeHandle, Delegate45.delegate45_0) }, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate298.delegate298_0));
													}
													replikantoAccount = target5(callSite_5, NetworkBroker.<>o__27.yAvjYhdtGI.Target(NetworkBroker.<>o__27.yAvjYhdtGI, obj2));
												}
												catch
												{
												}
											}
										}
										if (NetworkBroker.<>o__27.callSite_11 == null)
										{
											NetworkBroker.<>o__27.callSite_11 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
										}
										Func<CallSite, object, bool> target6 = NetworkBroker.<>o__27.callSite_11.Target;
										CallSite callSite_6 = NetworkBroker.<>o__27.callSite_11;
										if (NetworkBroker.<>o__27.callSite_10 == null)
										{
											NetworkBroker.<>o__27.callSite_10 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ContainsKey", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
											{
												Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
												Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
											}, Delegate298.delegate298_0));
										}
										if (!target6(callSite_6, NetworkBroker.<>o__27.callSite_10.Target(NetworkBroker.<>o__27.callSite_10, obj, "replikanto_version")))
										{
											if (NetworkBroker.<>o__27.callSite_55 == null)
											{
												NetworkBroker.<>o__27.callSite_55 = CallSite<Func<CallSite, object, ReplikantoOrder>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(ReplikantoOrder).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
											}
											Func<CallSite, object, ReplikantoOrder> target7 = NetworkBroker.<>o__27.callSite_55.Target;
											CallSite callSite_7 = NetworkBroker.<>o__27.callSite_55;
											if (NetworkBroker.<>o__27.callSite_54 == null)
											{
												NetworkBroker.<>o__27.callSite_54 = CallSite<Func<CallSite, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ToObject", new Type[] { Delegate45.smethod_0(typeof(ReplikantoOrder).TypeHandle, Delegate45.delegate45_0) }, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate298.delegate298_0));
											}
											ReplikantoOrder replikantoOrder = target7(callSite_7, NetworkBroker.<>o__27.callSite_54.Target(NetworkBroker.<>o__27.callSite_54, obj));
											try
											{
												ReplikantoOrder replikantoOrder2 = replikantoOrder;
												if (NetworkBroker.<>o__27.callSite_57 == null)
												{
													NetworkBroker.<>o__27.callSite_57 = CallSite<Func<CallSite, object, bool>>.Create(Delegate296.smethod_0(CSharpBinderFlags.ConvertExplicit, Delegate45.smethod_0(typeof(bool).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
												}
												Func<CallSite, object, bool> target8 = NetworkBroker.<>o__27.callSite_57.Target;
												CallSite callSite_8 = NetworkBroker.<>o__27.callSite_57;
												if (NetworkBroker.<>o__27.callSite_56 == null)
												{
													NetworkBroker.<>o__27.callSite_56 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
													{
														Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
														Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
													}, Delegate305.delegate305_0));
												}
												replikantoOrder2.BlockCopy = target8(callSite_8, NetworkBroker.<>o__27.callSite_56.Target(NetworkBroker.<>o__27.callSite_56, obj, "block_copy"));
											}
											catch
											{
											}
											Action<string, ReplikantoAccount, ReplikantoOrder> action = this.action_0;
											if (action != null)
											{
												action(text, replikantoAccount, replikantoOrder);
											}
											jobject["status"] = true;
										}
										else
										{
											if (NetworkBroker.<>o__27.callSite_13 == null)
											{
												NetworkBroker.<>o__27.callSite_13 = CallSite<Func<CallSite, object, string>>.Create(Delegate296.smethod_0(CSharpBinderFlags.ConvertExplicit, Delegate45.smethod_0(typeof(string).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
											}
											Func<CallSite, object, string> target9 = NetworkBroker.<>o__27.callSite_13.Target;
											CallSite callSite_9 = NetworkBroker.<>o__27.callSite_13;
											if (NetworkBroker.<>o__27.callSite_12 == null)
											{
												NetworkBroker.<>o__27.callSite_12 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
												{
													Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
													Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
												}, Delegate305.delegate305_0));
											}
											if (Delegate295.smethod_0(Delegate294.smethod_0(target9(callSite_9, NetworkBroker.<>o__27.callSite_12.Target(NetworkBroker.<>o__27.callSite_12, obj, "replikanto_version")), Delegate294.delegate294_0), this.version_0, Delegate295.delegate295_0) > 0)
											{
												Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: ", Resources.VersionWarningDuringReceivingTrades, Delegate33.delegate33_0), 2, Delegate34.delegate34_0);
											}
											bool flag = true;
											if (NetworkBroker.<>o__27.callSite_17 == null)
											{
												NetworkBroker.<>o__27.callSite_17 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
											}
											Func<CallSite, object, bool> target10 = NetworkBroker.<>o__27.callSite_17.Target;
											CallSite callSite_10 = NetworkBroker.<>o__27.callSite_17;
											if (NetworkBroker.<>o__27.callSite_16 == null)
											{
												NetworkBroker.<>o__27.callSite_16 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate302.smethod_0(CSharpBinderFlags.None, ExpressionType.Equal, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
												{
													Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
													Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
												}, Delegate302.delegate302_0));
											}
											Func<CallSite, object, string, object> target11 = NetworkBroker.<>o__27.callSite_16.Target;
											CallSite callSite_11 = NetworkBroker.<>o__27.callSite_16;
											if (NetworkBroker.<>o__27.callSite_15 == null)
											{
												NetworkBroker.<>o__27.callSite_15 = CallSite<Func<CallSite, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ToString", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate298.delegate298_0));
											}
											Func<CallSite, object, object> target12 = NetworkBroker.<>o__27.callSite_15.Target;
											CallSite callSite_12 = NetworkBroker.<>o__27.callSite_15;
											if (NetworkBroker.<>o__27.callSite_14 == null)
											{
												NetworkBroker.<>o__27.callSite_14 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
												{
													Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
													Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
												}, Delegate305.delegate305_0));
											}
											if (!target10(callSite_10, target11(callSite_11, target12(callSite_12, NetworkBroker.<>o__27.callSite_14.Target(NetworkBroker.<>o__27.callSite_14, obj, "action")), "OnInstrumentUpdate")))
											{
												if (NetworkBroker.<>o__27.callSite_38 == null)
												{
													NetworkBroker.<>o__27.callSite_38 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
												}
												Func<CallSite, object, bool> target13 = NetworkBroker.<>o__27.callSite_38.Target;
												CallSite callSite_13 = NetworkBroker.<>o__27.callSite_38;
												if (NetworkBroker.<>o__27.callSite_37 == null)
												{
													NetworkBroker.<>o__27.callSite_37 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate302.smethod_0(CSharpBinderFlags.None, ExpressionType.Equal, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
													{
														Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
														Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
													}, Delegate302.delegate302_0));
												}
												Func<CallSite, object, string, object> target14 = NetworkBroker.<>o__27.callSite_37.Target;
												CallSite callSite_14 = NetworkBroker.<>o__27.callSite_37;
												if (NetworkBroker.<>o__27.callSite_36 == null)
												{
													NetworkBroker.<>o__27.callSite_36 = CallSite<Func<CallSite, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ToString", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate298.delegate298_0));
												}
												Func<CallSite, object, object> target15 = NetworkBroker.<>o__27.callSite_36.Target;
												CallSite callSite_15 = NetworkBroker.<>o__27.callSite_36;
												if (NetworkBroker.<>o__27.callSite_35 == null)
												{
													NetworkBroker.<>o__27.callSite_35 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
													{
														Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
														Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
													}, Delegate305.delegate305_0));
												}
												if (!target13(callSite_13, target14(callSite_14, target15(callSite_15, NetworkBroker.<>o__27.callSite_35.Target(NetworkBroker.<>o__27.callSite_35, obj, "action")), "OnOrderUpdate")))
												{
													goto IL_1A42;
												}
												try
												{
													if (NetworkBroker.<>o__27.callSite_45 == null)
													{
														NetworkBroker.<>o__27.callSite_45 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
													}
													Func<CallSite, object, bool> target16 = NetworkBroker.<>o__27.callSite_45.Target;
													CallSite callSite_16 = NetworkBroker.<>o__27.callSite_45;
													object obj3;
													if (!flag)
													{
														obj3 = flag;
													}
													else
													{
														if (NetworkBroker.<>o__27.callSite_40 == null)
														{
															NetworkBroker.<>o__27.callSite_40 = CallSite<Func<CallSite, bool, object, object>>.Create(Delegate302.smethod_0(CSharpBinderFlags.BinaryOperationLogical, ExpressionType.And, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
															{
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0)
															}, Delegate302.delegate302_0));
														}
														Func<CallSite, bool, object, object> target17 = NetworkBroker.<>o__27.callSite_40.Target;
														CallSite callSite_17 = NetworkBroker.<>o__27.callSite_40;
														bool flag2 = flag;
														if (NetworkBroker.<>o__27.callSite_39 == null)
														{
															NetworkBroker.<>o__27.callSite_39 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ContainsKey", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
															{
																Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
															}, Delegate298.delegate298_0));
														}
														obj3 = target17(callSite_17, flag2, NetworkBroker.<>o__27.callSite_39.Target(NetworkBroker.<>o__27.callSite_39, obj, "machine_id"));
													}
													object obj4 = obj3;
													if (NetworkBroker.<>o__27.callSite_44 == null)
													{
														NetworkBroker.<>o__27.callSite_44 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsFalse, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
													}
													object obj5;
													if (NetworkBroker.<>o__27.callSite_44.Target(NetworkBroker.<>o__27.callSite_44, obj4))
													{
														obj5 = obj4;
													}
													else
													{
														if (NetworkBroker.<>o__27.callSite_43 == null)
														{
															NetworkBroker.<>o__27.callSite_43 = CallSite<Func<CallSite, object, bool, object>>.Create(Delegate302.smethod_0(CSharpBinderFlags.BinaryOperationLogical, ExpressionType.And, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
															{
																Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType, null, Delegate297.delegate297_0)
															}, Delegate302.delegate302_0));
														}
														Func<CallSite, object, bool, object> target18 = NetworkBroker.<>o__27.callSite_43.Target;
														CallSite callSite_18 = NetworkBroker.<>o__27.callSite_43;
														object obj6 = obj4;
														string machineIdSigned = ReplikantoFramework.MachineIdSigned;
														if (NetworkBroker.<>o__27.callSite_42 == null)
														{
															NetworkBroker.<>o__27.callSite_42 = CallSite<Func<CallSite, object, string>>.Create(Delegate296.smethod_0(CSharpBinderFlags.ConvertExplicit, Delegate45.smethod_0(typeof(string).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
														}
														Func<CallSite, object, string> target19 = NetworkBroker.<>o__27.callSite_42.Target;
														CallSite callSite_19 = NetworkBroker.<>o__27.callSite_42;
														if (NetworkBroker.<>o__27.callSite_41 == null)
														{
															NetworkBroker.<>o__27.callSite_41 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
															{
																Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
															}, Delegate305.delegate305_0));
														}
														obj5 = target18(callSite_18, obj6, Delegate102.smethod_0(machineIdSigned, target19(callSite_19, NetworkBroker.<>o__27.callSite_41.Target(NetworkBroker.<>o__27.callSite_41, obj, "machine_id")), Delegate102.delegate102_0));
													}
													if (!target16(callSite_16, obj5))
													{
														if (NetworkBroker.<>o__27.callSite_51 == null)
														{
															NetworkBroker.<>o__27.callSite_51 = CallSite<Func<CallSite, object, ReplikantoOrder>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(ReplikantoOrder).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
														}
														Func<CallSite, object, ReplikantoOrder> target20 = NetworkBroker.<>o__27.callSite_51.Target;
														CallSite callSite_20 = NetworkBroker.<>o__27.callSite_51;
														if (NetworkBroker.<>o__27.callSite_50 == null)
														{
															NetworkBroker.<>o__27.callSite_50 = CallSite<Func<CallSite, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ToObject", new Type[] { Delegate45.smethod_0(typeof(ReplikantoOrder).TypeHandle, Delegate45.delegate45_0) }, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate298.delegate298_0));
														}
														Func<CallSite, object, object> target21 = NetworkBroker.<>o__27.callSite_50.Target;
														CallSite callSite_21 = NetworkBroker.<>o__27.callSite_50;
														if (NetworkBroker.<>o__27.callSite_49 == null)
														{
															NetworkBroker.<>o__27.callSite_49 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
															{
																Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
															}, Delegate305.delegate305_0));
														}
														ReplikantoOrder replikantoOrder3 = target20(callSite_20, target21(callSite_21, NetworkBroker.<>o__27.callSite_49.Target(NetworkBroker.<>o__27.callSite_49, obj, "trade")));
														if (replikantoAccount != null)
														{
															replikantoOrder3.ReplikantoAccount = replikantoAccount;
														}
														try
														{
															ReplikantoOrder replikantoOrder4 = replikantoOrder3;
															if (NetworkBroker.<>o__27.callSite_53 == null)
															{
																NetworkBroker.<>o__27.callSite_53 = CallSite<Func<CallSite, object, bool>>.Create(Delegate296.smethod_0(CSharpBinderFlags.ConvertExplicit, Delegate45.smethod_0(typeof(bool).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
															}
															Func<CallSite, object, bool> target22 = NetworkBroker.<>o__27.callSite_53.Target;
															CallSite callSite_22 = NetworkBroker.<>o__27.callSite_53;
															if (NetworkBroker.<>o__27.callSite_52 == null)
															{
																NetworkBroker.<>o__27.callSite_52 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
																{
																	Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
																	Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
																}, Delegate305.delegate305_0));
															}
															replikantoOrder4.BlockCopy = target22(callSite_22, NetworkBroker.<>o__27.callSite_52.Target(NetworkBroker.<>o__27.callSite_52, obj, "block_copy"));
														}
														catch
														{
														}
														Action<string, ReplikantoAccount, ReplikantoOrder> action2 = this.action_0;
														if (action2 != null)
														{
															action2(text, replikantoAccount, replikantoOrder3);
														}
														jobject["status"] = true;
													}
													else
													{
														jobject["status"] = false;
														JObject jobject2 = jobject;
														string text2 = "msg";
														if (NetworkBroker.<>o__27.callSite_48 == null)
														{
															NetworkBroker.<>o__27.callSite_48 = CallSite<Func<CallSite, object, JToken>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(JToken).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
														}
														Func<CallSite, object, JToken> target23 = NetworkBroker.<>o__27.callSite_48.Target;
														CallSite callSite_23 = NetworkBroker.<>o__27.callSite_48;
														if (NetworkBroker.<>o__27.callSite_47 == null)
														{
															NetworkBroker.<>o__27.callSite_47 = CallSite<Func<CallSite, Type, string, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "Format", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
															{
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.IsStaticType, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0)
															}, Delegate298.delegate298_0));
														}
														Func<CallSite, Type, string, object, object> target24 = NetworkBroker.<>o__27.callSite_47.Target;
														CallSite callSite_24 = NetworkBroker.<>o__27.callSite_47;
														Type type = Delegate45.smethod_0(typeof(string).TypeHandle, Delegate45.delegate45_0);
														string leaderFollowerSameMachineID = Resources.LeaderFollowerSameMachineID;
														if (NetworkBroker.<>o__27.callSite_46 == null)
														{
															NetworkBroker.<>o__27.callSite_46 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
															{
																Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
																Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
															}, Delegate305.delegate305_0));
														}
														jobject2[text2] = target23(callSite_23, target24(callSite_24, type, leaderFollowerSameMachineID, NetworkBroker.<>o__27.callSite_46.Target(NetworkBroker.<>o__27.callSite_46, obj, "machine_id")));
													}
													goto IL_1A42;
												}
												catch
												{
													goto IL_1A42;
												}
											}
											try
											{
												if (NetworkBroker.<>o__27.callSite_24 == null)
												{
													NetworkBroker.<>o__27.callSite_24 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsTrue, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
												}
												Func<CallSite, object, bool> target25 = NetworkBroker.<>o__27.callSite_24.Target;
												CallSite callSite_25 = NetworkBroker.<>o__27.callSite_24;
												object obj7;
												if (flag)
												{
													if (NetworkBroker.<>o__27.callSite_19 == null)
													{
														NetworkBroker.<>o__27.callSite_19 = CallSite<Func<CallSite, bool, object, object>>.Create(Delegate302.smethod_0(CSharpBinderFlags.BinaryOperationLogical, ExpressionType.And, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0)
														}, Delegate302.delegate302_0));
													}
													Func<CallSite, bool, object, object> target26 = NetworkBroker.<>o__27.callSite_19.Target;
													CallSite callSite_26 = NetworkBroker.<>o__27.callSite_19;
													bool flag3 = flag;
													if (NetworkBroker.<>o__27.callSite_18 == null)
													{
														NetworkBroker.<>o__27.callSite_18 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ContainsKey", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
														}, Delegate298.delegate298_0));
													}
													obj7 = target26(callSite_26, flag3, NetworkBroker.<>o__27.callSite_18.Target(NetworkBroker.<>o__27.callSite_18, obj, "machine_id"));
												}
												else
												{
													obj7 = flag;
												}
												object obj4 = obj7;
												if (NetworkBroker.<>o__27.callSite_23 == null)
												{
													NetworkBroker.<>o__27.callSite_23 = CallSite<Func<CallSite, object, bool>>.Create(Delegate301.smethod_0(CSharpBinderFlags.None, ExpressionType.IsFalse, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate301.delegate301_0));
												}
												object obj8;
												if (NetworkBroker.<>o__27.callSite_23.Target(NetworkBroker.<>o__27.callSite_23, obj4))
												{
													obj8 = obj4;
												}
												else
												{
													if (NetworkBroker.<>o__27.callSite_22 == null)
													{
														NetworkBroker.<>o__27.callSite_22 = CallSite<Func<CallSite, object, bool, object>>.Create(Delegate302.smethod_0(CSharpBinderFlags.BinaryOperationLogical, ExpressionType.And, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType, null, Delegate297.delegate297_0)
														}, Delegate302.delegate302_0));
													}
													Func<CallSite, object, bool, object> target27 = NetworkBroker.<>o__27.callSite_22.Target;
													CallSite callSite_27 = NetworkBroker.<>o__27.callSite_22;
													object obj9 = obj4;
													string machineIdSigned2 = ReplikantoFramework.MachineIdSigned;
													if (NetworkBroker.<>o__27.callSite_21 == null)
													{
														NetworkBroker.<>o__27.callSite_21 = CallSite<Func<CallSite, object, string>>.Create(Delegate296.smethod_0(CSharpBinderFlags.ConvertExplicit, Delegate45.smethod_0(typeof(string).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
													}
													Func<CallSite, object, string> target28 = NetworkBroker.<>o__27.callSite_21.Target;
													CallSite callSite_28 = NetworkBroker.<>o__27.callSite_21;
													if (NetworkBroker.<>o__27.callSite_20 == null)
													{
														NetworkBroker.<>o__27.callSite_20 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
														}, Delegate305.delegate305_0));
													}
													obj8 = target27(callSite_27, obj9, Delegate102.smethod_0(machineIdSigned2, target28(callSite_28, NetworkBroker.<>o__27.callSite_20.Target(NetworkBroker.<>o__27.callSite_20, obj, "machine_id")), Delegate102.delegate102_0));
												}
												if (!target25(callSite_25, obj8))
												{
													if (NetworkBroker.<>o__27.callSite_30 == null)
													{
														NetworkBroker.<>o__27.callSite_30 = CallSite<Func<CallSite, object, Instrument>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(Instrument).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
													}
													Func<CallSite, object, Instrument> target29 = NetworkBroker.<>o__27.callSite_30.Target;
													CallSite callSite_29 = NetworkBroker.<>o__27.callSite_30;
													if (NetworkBroker.<>o__27.NcmjuewuVA == null)
													{
														NetworkBroker.<>o__27.NcmjuewuVA = CallSite<Func<CallSite, Type, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "GetInstrument", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.IsStaticType, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0)
														}, Delegate298.delegate298_0));
													}
													Func<CallSite, Type, object, object> target30 = NetworkBroker.<>o__27.NcmjuewuVA.Target;
													CallSite ncmjuewuVA = NetworkBroker.<>o__27.NcmjuewuVA;
													Type type2 = Delegate45.smethod_0(typeof(Instrument).TypeHandle, Delegate45.delegate45_0);
													if (NetworkBroker.<>o__27.callSite_29 == null)
													{
														NetworkBroker.<>o__27.callSite_29 = CallSite<Func<CallSite, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ToString", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate298.delegate298_0));
													}
													Func<CallSite, object, object> target31 = NetworkBroker.<>o__27.callSite_29.Target;
													CallSite callSite_30 = NetworkBroker.<>o__27.callSite_29;
													if (NetworkBroker.<>o__27.callSite_28 == null)
													{
														NetworkBroker.<>o__27.callSite_28 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
														}, Delegate305.delegate305_0));
													}
													Instrument instrument = target29(callSite_29, target30(ncmjuewuVA, type2, target31(callSite_30, NetworkBroker.<>o__27.callSite_28.Target(NetworkBroker.<>o__27.callSite_28, obj, "oldInstrument"))));
													if (NetworkBroker.<>o__27.callSite_34 == null)
													{
														NetworkBroker.<>o__27.callSite_34 = CallSite<Func<CallSite, object, Instrument>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(Instrument).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
													}
													Func<CallSite, object, Instrument> target32 = NetworkBroker.<>o__27.callSite_34.Target;
													CallSite callSite_31 = NetworkBroker.<>o__27.callSite_34;
													if (NetworkBroker.<>o__27.callSite_33 == null)
													{
														NetworkBroker.<>o__27.callSite_33 = CallSite<Func<CallSite, Type, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "GetInstrument", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.IsStaticType, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0)
														}, Delegate298.delegate298_0));
													}
													Func<CallSite, Type, object, object> target33 = NetworkBroker.<>o__27.callSite_33.Target;
													CallSite callSite_32 = NetworkBroker.<>o__27.callSite_33;
													Type type3 = Delegate45.smethod_0(typeof(Instrument).TypeHandle, Delegate45.delegate45_0);
													if (NetworkBroker.<>o__27.callSite_32 == null)
													{
														NetworkBroker.<>o__27.callSite_32 = CallSite<Func<CallSite, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "ToString", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[] { Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0) }, Delegate298.delegate298_0));
													}
													Func<CallSite, object, object> target34 = NetworkBroker.<>o__27.callSite_32.Target;
													CallSite callSite_33 = NetworkBroker.<>o__27.callSite_32;
													if (NetworkBroker.<>o__27.callSite_31 == null)
													{
														NetworkBroker.<>o__27.callSite_31 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
														}, Delegate305.delegate305_0));
													}
													Instrument instrument2 = target32(callSite_31, target33(callSite_32, type3, target34(callSite_33, NetworkBroker.<>o__27.callSite_31.Target(NetworkBroker.<>o__27.callSite_31, obj, "instrument"))));
													Action<string, ReplikantoAccount, Instrument, Instrument> action3 = this.action_1;
													if (action3 != null)
													{
														action3(text, replikantoAccount, instrument, instrument2);
													}
													jobject["status"] = true;
												}
												else
												{
													jobject["status"] = false;
													JObject jobject3 = jobject;
													string text3 = "msg";
													if (NetworkBroker.<>o__27.callSite_27 == null)
													{
														NetworkBroker.<>o__27.callSite_27 = CallSite<Func<CallSite, object, JToken>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(JToken).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
													}
													Func<CallSite, object, JToken> target35 = NetworkBroker.<>o__27.callSite_27.Target;
													CallSite callSite_34 = NetworkBroker.<>o__27.callSite_27;
													if (NetworkBroker.<>o__27.callSite_26 == null)
													{
														NetworkBroker.<>o__27.callSite_26 = CallSite<Func<CallSite, Type, string, object, object>>.Create(Delegate298.smethod_0(CSharpBinderFlags.None, "Format", null, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.IsStaticType, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0)
														}, Delegate298.delegate298_0));
													}
													Func<CallSite, Type, string, object, object> target36 = NetworkBroker.<>o__27.callSite_26.Target;
													CallSite callSite_35 = NetworkBroker.<>o__27.callSite_26;
													Type type4 = Delegate45.smethod_0(typeof(string).TypeHandle, Delegate45.delegate45_0);
													string leaderFollowerSameMachineID2 = Resources.LeaderFollowerSameMachineID;
													if (NetworkBroker.<>o__27.callSite_25 == null)
													{
														NetworkBroker.<>o__27.callSite_25 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(NetworkBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
														{
															Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
															Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
														}, Delegate305.delegate305_0));
													}
													jobject3[text3] = target35(callSite_34, target36(callSite_35, type4, leaderFollowerSameMachineID2, NetworkBroker.<>o__27.callSite_25.Target(NetworkBroker.<>o__27.callSite_25, obj, "machine_id")));
												}
											}
											catch
											{
											}
										}
										IL_1A42:;
									}
									finally
									{
										if (jsonReader != null)
										{
											Delegate39.smethod_0(jsonReader, Delegate39.delegate39_0);
										}
									}
								}
								finally
								{
									if (streamReader != null)
									{
										Delegate39.smethod_0(streamReader, Delegate39.delegate39_0);
									}
								}
							}
							finally
							{
								if (stream != null)
								{
									Delegate39.smethod_0(stream, Delegate39.delegate39_0);
								}
							}
						}
					}
					catch (HttpListenerException ex)
					{
						jobject["status"] = false;
						jobject["msg"] = Delegate31.smethod_0(ex, Delegate31.delegate31_0);
					}
					catch (Exception ex2)
					{
						Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: {0}", ex2, Delegate32.delegate32_0), 3, Delegate34.delegate34_0);
						Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Error reading the msg: \"", Delegate31.smethod_0(ex2, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
						jobject["status"] = false;
						jobject["msg"] = Delegate31.smethod_0(ex2, Delegate31.delegate31_0);
					}
				}
			}
			catch (Exception)
			{
			}
			try
			{
				if (httpListenerContext != null && Delegate617.smethod_0(httpListenerContext, Delegate617.delegate617_0) != null)
				{
					string text4 = Delegate86.smethod_0(jobject, Delegate86.delegate86_0);
					byte[] array = Delegate619.smethod_0(Delegate618.smethod_0(Delegate618.delegate618_0), text4, Delegate619.delegate619_0);
					Delegate620.smethod_0(Delegate617.smethod_0(httpListenerContext, Delegate617.delegate617_0), (long)array.Length, Delegate620.delegate620_0);
					Delegate621.smethod_0(Delegate617.smethod_0(httpListenerContext, Delegate617.delegate617_0), array, true, Delegate621.MoNrkYcMyK);
				}
			}
			catch (Exception ex3)
			{
				Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: {0}", ex3, Delegate32.delegate32_0), 3, Delegate34.delegate34_0);
				Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Error trying to response to the leader: \"", Delegate31.smethod_0(ex3, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
			}
			try
			{
				Delegate601.smethod_0(this.httpListener_0, new AsyncCallback(this.method_0), this.httpListener_0, Delegate601.delegate601_0);
			}
			catch (Exception ex4)
			{
				Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: {0}", ex4, Delegate32.delegate32_0), 3, Delegate34.delegate34_0);
				Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Error trying to listener again: \"", Delegate31.smethod_0(ex4, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
			}
		}

		private void method_1()
		{
			if (this.httpListener_0 != null)
			{
				try
				{
					try
					{
						Delegate622.smethod_0(this.httpListener_0, Delegate622.delegate622_0);
					}
					catch (Exception)
					{
					}
					try
					{
						Delegate623.smethod_0(this.httpListener_0, Delegate623.delegate623_0);
					}
					catch (Exception)
					{
					}
					try
					{
						Delegate624.smethod_0(this.httpListener_0, Delegate624.delegate624_0);
					}
					catch (Exception)
					{
					}
				}
				finally
				{
					this.httpListener_0 = null;
				}
			}
		}

		internal void Stop()
		{
			if (this.httpListener_0 != null)
			{
				this.method_1();
				Action action = this.action_3;
				if (action != null)
				{
					action();
				}
				Delegate34.smethod_0("Replikanto: The server has stopped", 1, Delegate34.delegate34_0);
			}
		}

		internal static void smethod_0()
		{
		}

		internal static object smethod_1(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static void smethod_2()
		{
		}

		internal static void smethod_3(object object_0)
		{
			object_0();
		}

		internal static object smethod_4(object object_0, object object_1)
		{
			return object_0.Deserialize(object_1);
		}

		internal static object smethod_5(bool bool_0)
		{
			return bool_0;
		}

		internal static void smethod_6(object object_0, object object_1, object object_2)
		{
			object_0[object_1] = object_2;
		}

		internal static object smethod_7()
		{
			return Resources.LeaderFollowerSameMachineID;
		}

		internal static void smethod_8(object object_0, bool value)
		{
			object_0.BlockCopy = value;
		}

		internal static object smethod_9(object object_0)
		{
			return object_0;
		}

		internal static void smethod_10()
		{
		}

		private HttpListener httpListener_0;

		[CompilerGenerated]
		private Action<string, ReplikantoAccount, ReplikantoOrder> action_0;

		[CompilerGenerated]
		private Action<string, ReplikantoAccount, Instrument, Instrument> action_1;

		[CompilerGenerated]
		private Action action_2;

		[CompilerGenerated]
		private Action action_3;

		private Version version_0;

		private string string_0;

		private string string_1;

		[CompilerGenerated]
		private uint uint_0;
	}
}
