﻿using System;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Net.WebSockets;
using System.Runtime.CompilerServices;
using System.Security.Cryptography;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.CSharp.RuntimeBinder;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using NinjaTrader.NinjaScript.AddOns.FlowBots;
using Replikanto.Util;
using Websocket.Client;
using Websocket.Client.Models;

namespace Replikanto.Communicator
{
	internal class CommunicatorBroker
	{
		internal event Action<JObject, LeaderOrderSource> MessageReceived
		{
			[CompilerGenerated]
			add
			{
				Action<JObject, LeaderOrderSource> action = this.action_0;
				Action<JObject, LeaderOrderSource> action2;
				do
				{
					action2 = action;
					Action<JObject, LeaderOrderSource> action3 = (Action<JObject, LeaderOrderSource>)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action<JObject, LeaderOrderSource>>(ref this.action_0, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action<JObject, LeaderOrderSource> action = this.action_0;
				Action<JObject, LeaderOrderSource> action2;
				do
				{
					action2 = action;
					Action<JObject, LeaderOrderSource> action3 = (Action<JObject, LeaderOrderSource>)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action<JObject, LeaderOrderSource>>(ref this.action_0, action3, action2);
				}
				while (action != action2);
			}
		}

		internal event Action<string> Error
		{
			[CompilerGenerated]
			add
			{
				Action<string> action = this.action_1;
				Action<string> action2;
				do
				{
					action2 = action;
					Action<string> action3 = (Action<string>)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action<string>>(ref this.action_1, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action<string> action = this.action_1;
				Action<string> action2;
				do
				{
					action2 = action;
					Action<string> action3 = (Action<string>)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action<string>>(ref this.action_1, action3, action2);
				}
				while (action != action2);
			}
		}

		internal event Action Connected
		{
			[CompilerGenerated]
			add
			{
				Action action = this.action_2;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_2, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action action = this.action_2;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_2, action3, action2);
				}
				while (action != action2);
			}
		}

		internal event Action Connecting
		{
			[CompilerGenerated]
			add
			{
				Action action = this.action_3;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_3, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action action = this.action_3;
				Action action2;
				do
				{
					action2 = action;
					Action action3 = (Action)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action>(ref this.action_3, action3, action2);
				}
				while (action != action2);
			}
		}

		internal event Action<DisconnectionType> Disconnected
		{
			[CompilerGenerated]
			add
			{
				Action<DisconnectionType> action = this.action_4;
				Action<DisconnectionType> action2;
				do
				{
					action2 = action;
					Action<DisconnectionType> action3 = (Action<DisconnectionType>)Delegate544.smethod_0(action2, value, Delegate544.delegate544_0);
					action = Interlocked.CompareExchange<Action<DisconnectionType>>(ref this.action_4, action3, action2);
				}
				while (action != action2);
			}
			[CompilerGenerated]
			remove
			{
				Action<DisconnectionType> action = this.action_4;
				Action<DisconnectionType> action2;
				do
				{
					action2 = action;
					Action<DisconnectionType> action3 = (Action<DisconnectionType>)Delegate545.smethod_0(action2, value, Delegate545.delegate545_0);
					action = Interlocked.CompareExchange<Action<DisconnectionType>>(ref this.action_4, action3, action2);
				}
				while (action != action2);
			}
		}

		public CommunicatorBroker()
		{
			Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Api Key \"...", Delegate428.smethod_0(CommunicatorBroker.string_0, Delegate99.smethod_0(CommunicatorBroker.string_0, Delegate99.delegate99_0) - 5, Delegate428.delegate428_0), "\"", Delegate51.delegate51_0), 1, Delegate34.delegate34_0);
			try
			{
				Delegate590.smethod_0(Delegate428.smethod_0(this.string_6, 6, Delegate428.delegate428_0), Delegate590.delegate590_0);
			}
			catch (Exception ex)
			{
				Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: DNS Host Entry message \"", Delegate31.smethod_0(ex, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 1, Delegate34.delegate34_0);
				this.string_6 = "wss://u2ngp3k7z7.execute-api.us-east-1.amazonaws.com/production/";
				Delegate34.smethod_0("Replikanto: Websocket u2...z7 url will be used", 1, Delegate34.delegate34_0);
			}
		}

		protected override void Finalize()
		{
			try
			{
				try
				{
					Registry.GetInstance().DelKey("guid");
				}
				catch
				{
				}
				this.Stop();
			}
			finally
			{
				Delegate196.smethod_0(this, Delegate196.delegate196_0);
			}
		}

		internal void Stop()
		{
			if (this.websocketClient_0 != null && this.websocketClient_0.IsRunning)
			{
				try
				{
					this.websocketClient_0.ErrorReconnectTimeout = null;
					this.websocketClient_0.Stop(WebSocketCloseStatus.NormalClosure, "Terminate");
					this.websocketClient_0.Dispose();
					this.websocketClient_0 = null;
				}
				catch
				{
				}
				finally
				{
					Delegate34.smethod_0("Replikanto: Communicator terminate", 1, Delegate34.delegate34_0);
				}
			}
		}

		internal Task StartWSConnection()
		{
			CommunicatorBroker.<StartWSConnection>d__33 <StartWSConnection>d__;
			<StartWSConnection>d__.<>t__builder = Delegate425.smethod_0(Delegate425.delegate425_0);
			<StartWSConnection>d__.<>4__this = this;
			<StartWSConnection>d__.<>1__state = -1;
			<StartWSConnection>d__.<>t__builder.Start<CommunicatorBroker.<StartWSConnection>d__33>(ref <StartWSConnection>d__);
			return Delegate426.smethod_0(ref <StartWSConnection>d__.<>t__builder, Delegate426.delegate426_0);
		}

		public void StopReconnecting()
		{
			if (this.websocketClient_0 != null)
			{
				this.websocketClient_0.ErrorReconnectTimeout = null;
			}
		}

		public bool Boolean_0
		{
			get
			{
				return this.websocketClient_0 != null && this.websocketClient_0.IsRunning;
			}
		}

		public bool Boolean_1
		{
			get
			{
				return this.websocketClient_0 != null && this.websocketClient_0.IsStarted;
			}
		}

		public async Task<bool> SendMessageByWS(JObject msgObj)
		{
			bool flag;
			if (this.websocketClient_0 != null && this.websocketClient_0.IsRunning && this.websocketClient_0.IsStarted)
			{
				msgObj["machine_id"] = ReplikantoFramework.MachineIdSigned;
				msgObj["replikanto_version"] = Delegate86.smethod_0(Delegate48.smethod_0(Delegate47.smethod_0(Delegate248.smethod_0(Delegate248.delegate248_0), Delegate47.delegate47_0), Delegate48.delegate48_0), Delegate86.delegate86_0);
				msgObj["msg_id"] = (CommunicatorBroker.long_0 += 1L);
				string text = msgObj.ToString(Formatting.None, Array.Empty<JsonConverter>());
				try
				{
					int num = Delegate700.smethod_0(Delegate699.smethod_0(Delegate699.delegate699_0), text, Delegate700.delegate700_0);
					if (num > 32768)
					{
						Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: Messages larger than 32kb ({0}kb) cannot be submitted via WSs", num / 1024, Delegate32.delegate32_0), 2, Delegate34.delegate34_0);
						return false;
					}
				}
				catch (Exception)
				{
				}
				TaskAwaiter taskAwaiter = Delegate632.smethod_0(this.websocketClient_0.SendInstant(text), Delegate632.delegate632_0);
				if (!Delegate633.smethod_0(ref taskAwaiter, Delegate633.delegate633_0))
				{
					await taskAwaiter;
					TaskAwaiter taskAwaiter2;
					taskAwaiter = taskAwaiter2;
					taskAwaiter2 = default(TaskAwaiter);
				}
				Delegate634.smethod_0(ref taskAwaiter, Delegate634.delegate634_0);
				flag = true;
			}
			else
			{
				flag = false;
			}
			return flag;
		}

		public async Task<JObject> GetReplikantoNodeInfoByHTTP()
		{
			string text = (this.bool_0 ? this.string_4 : this.string_5);
			try
			{
				WebRequest webRequest = Delegate701.smethod_0(Delegate33.smethod_0(text, "/nodeinfo", Delegate33.delegate33_0), Delegate701.delegate701_0);
				Delegate702.smethod_0(webRequest, 12000, Delegate702.delegate702_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "x-api-key", CommunicatorBroker.string_0, Delegate704.delegate704_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "Machine-Id", ReplikantoFramework.MachineIdSigned, Delegate704.delegate704_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "Replikanto-Version", Delegate86.smethod_0(Delegate48.smethod_0(Delegate47.smethod_0(Delegate248.smethod_0(Delegate248.delegate248_0), Delegate47.delegate47_0), Delegate48.delegate48_0), Delegate86.delegate86_0), Delegate704.delegate704_0);
				Delegate706.smethod_0(webRequest, Delegate705.smethod_0(Delegate705.delegate705_0), Delegate706.delegate706_0);
				TaskAwaiter<WebResponse> taskAwaiter = Delegate707.smethod_0(webRequest, Delegate707.delegate707_0).GetAwaiter();
				if (!taskAwaiter.IsCompleted)
				{
					goto IL_03A3;
				}
				IL_0142:
				Stream dataStream = Delegate708.smethod_0(taskAwaiter.GetResult(), Delegate708.delegate708_0);
				try
				{
					JObject jobject = JObject.Parse(await Delegate709.smethod_0(new StreamReader(dataStream), Delegate709.delegate709_0));
					object obj = JObject.Parse((string)jobject["body"]);
					if (CommunicatorBroker.<>o__40.callSite_0 == null)
					{
						CommunicatorBroker.<>o__40.callSite_0 = CallSite<Func<CallSite, object, string>>.Create(Delegate296.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(string).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(CommunicatorBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
					}
					Func<CallSite, object, string> target = CommunicatorBroker.<>o__40.callSite_0.Target;
					CallSite callSite_ = CommunicatorBroker.<>o__40.callSite_0;
					if (CommunicatorBroker.<>o__40.jiajphvYa0 == null)
					{
						CommunicatorBroker.<>o__40.jiajphvYa0 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(CommunicatorBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
						{
							Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
							Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
						}, Delegate305.delegate305_0));
					}
					if (Delegate102.smethod_0(target(callSite_, CommunicatorBroker.<>o__40.jiajphvYa0.Target(CommunicatorBroker.<>o__40.jiajphvYa0, obj, "action")), "node_info", Delegate102.delegate102_0))
					{
						if (CommunicatorBroker.<>o__40.callSite_2 == null)
						{
							CommunicatorBroker.<>o__40.callSite_2 = CallSite<Func<CallSite, object, JObject>>.Create(Delegate296.smethod_0(CSharpBinderFlags.ConvertExplicit, Delegate45.smethod_0(typeof(JObject).TypeHandle, Delegate45.delegate45_0), Delegate45.smethod_0(typeof(CommunicatorBroker).TypeHandle, Delegate45.delegate45_0), Delegate296.delegate296_0));
						}
						Func<CallSite, object, JObject> target2 = CommunicatorBroker.<>o__40.callSite_2.Target;
						CallSite callSite_2 = CommunicatorBroker.<>o__40.callSite_2;
						if (CommunicatorBroker.<>o__40.callSite_1 == null)
						{
							CommunicatorBroker.<>o__40.callSite_1 = CallSite<Func<CallSite, object, string, object>>.Create(Delegate305.smethod_0(CSharpBinderFlags.None, Delegate45.smethod_0(typeof(CommunicatorBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
							{
								Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
								Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
							}, Delegate305.delegate305_0));
						}
						jobject = target2(callSite_2, CommunicatorBroker.<>o__40.callSite_1.Target(CommunicatorBroker.<>o__40.callSite_1, obj, "payload"));
					}
					return jobject;
				}
				finally
				{
					if (dataStream != null)
					{
						Delegate39.smethod_0(dataStream, Delegate39.delegate39_0);
					}
				}
				IL_03A3:
				await taskAwaiter;
				TaskAwaiter<WebResponse> taskAwaiter2;
				taskAwaiter = taskAwaiter2;
				taskAwaiter2 = default(TaskAwaiter<WebResponse>);
				goto IL_0142;
			}
			catch (WebException ex)
			{
				Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Error getting Replikanto Node information: \"", Delegate31.smethod_0(ex, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
				throw ex;
			}
			catch (Exception ex2)
			{
				Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Error getting Replikanto Node information: \"", Delegate31.smethod_0(ex2, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
				throw ex2;
			}
			JObject jobject2;
			return jobject2;
		}

		private static IPAddress smethod_0(string string_7 = "https://ipinfo.io/ip")
		{
			return Delegate592.smethod_0(Delegate591.smethod_0(new WebClient(), string_7, Delegate591.delegate591_0), Delegate592.delegate592_0);
		}

		internal async Task<uint> NotifyReplikantoActive()
		{
			IPAddress newIPAddress = null;
			try
			{
				newIPAddress = CommunicatorBroker.smethod_0("https://ipinfo.io/ip");
				if (this.ipaddress_0 != null && !Delegate172.smethod_0(this.ipaddress_0, newIPAddress, Delegate172.delegate172_0))
				{
					try
					{
						TaskAwaiter taskAwaiter = Delegate632.smethod_0(this.NotifyReplikantoDeactive(), Delegate632.delegate632_0);
						if (!Delegate633.smethod_0(ref taskAwaiter, Delegate633.delegate633_0))
						{
							await taskAwaiter;
							TaskAwaiter taskAwaiter2;
							taskAwaiter = taskAwaiter2;
							taskAwaiter2 = default(TaskAwaiter);
						}
						Delegate634.smethod_0(ref taskAwaiter, Delegate634.delegate634_0);
					}
					catch
					{
					}
				}
			}
			catch
			{
			}
			finally
			{
				this.ipaddress_0 = newIPAddress;
			}
			int num = 0;
			try
			{
				this.bool_0 = true;
				return await this.method_0(this.string_4);
			}
			catch (Exception obj)
			{
				num = 1;
			}
			if (num == 1)
			{
				object obj;
				Exception ex = (Exception)obj;
				try
				{
					this.bool_0 = false;
					return await this.method_0(this.string_5);
				}
				catch
				{
					throw ex;
				}
			}
			newIPAddress = null;
			uint num2;
			return num2;
		}

		private async Task<uint> method_0(string string_7)
		{
			try
			{
				string text = Delegate86.smethod_0(Delegate48.smethod_0(Delegate47.smethod_0(Delegate248.smethod_0(Delegate248.delegate248_0), Delegate47.delegate47_0), Delegate48.delegate48_0), Delegate86.delegate86_0);
				WebRequest webRequest = Delegate701.smethod_0(Delegate33.smethod_0(string_7, "/active", Delegate33.delegate33_0), Delegate701.delegate701_0);
				Delegate702.smethod_0(webRequest, 5000, Delegate702.delegate702_0);
				Delegate710.smethod_0(webRequest, "PUT", Delegate710.delegate710_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "x-api-key", CommunicatorBroker.string_0, Delegate704.delegate704_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "Machine-Id", ReplikantoFramework.MachineIdSigned, Delegate704.delegate704_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "Replikanto-Version", text, Delegate704.delegate704_0);
				string seed = Delegate176.smethod_0(Delegate176.delegate176_0).ToString();
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "guid", seed, Delegate704.delegate704_0);
				Delegate706.smethod_0(webRequest, Delegate705.smethod_0(Delegate705.delegate705_0), Delegate706.delegate706_0);
				TaskAwaiter<WebResponse> taskAwaiter = Delegate707.smethod_0(webRequest, Delegate707.delegate707_0).GetAwaiter();
				if (!taskAwaiter.IsCompleted)
				{
					goto IL_04DE;
				}
				IL_017B:
				Stream dataStream = Delegate708.smethod_0(taskAwaiter.GetResult(), Delegate708.delegate708_0);
				try
				{
					TaskAwaiter<string> taskAwaiter2 = Delegate709.smethod_0(new StreamReader(dataStream), Delegate709.delegate709_0).GetAwaiter();
					if (!taskAwaiter2.IsCompleted)
					{
						await taskAwaiter2;
						TaskAwaiter<string> taskAwaiter3;
						taskAwaiter2 = taskAwaiter3;
						taskAwaiter3 = default(TaskAwaiter<string>);
					}
					JObject jobject = JObject.Parse(taskAwaiter2.GetResult());
					JObject jobject2 = ((!jobject.ContainsKey("body")) ? jobject : JObject.Parse((string)jobject["body"]));
					if (!jobject2.ContainsKey("action"))
					{
						try
						{
							jobject = (JObject)jobject2["payload"];
							if (Delegate102.smethod_0(Delegate86.smethod_0(jobject["status"], Delegate86.delegate86_0), "error", Delegate102.delegate102_0))
							{
								Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: ", Delegate86.smethod_0(jobject["msg"], Delegate86.delegate86_0), Delegate33.delegate33_0), 3, Delegate34.delegate34_0);
							}
						}
						catch
						{
						}
						throw new ActiveCheckException();
					}
					if (!Delegate102.smethod_0(Delegate86.smethod_0(jobject2["action"], Delegate86.delegate86_0), "active_machine_id", Delegate102.delegate102_0))
					{
						throw new ActiveCheckException();
					}
					jobject = (JObject)jobject2["payload"];
					string text2 = Delegate86.smethod_0(jobject["status"], Delegate86.delegate86_0);
					if (!Delegate104.smethod_0(text2, "active", Delegate104.delegate104_0))
					{
						uint num = Delegate711.smethod_0(jobject["interval"], Delegate711.delegate711_0);
						string text3 = Delegate86.smethod_0(jobject["hash"], Delegate86.delegate86_0);
						string text4 = Delegate55.smethod_0("{0}:{1}:{2}:{3}", new object[]
						{
							ReplikantoFramework.MachineIdSigned,
							seed,
							text2,
							num
						}, Delegate55.delegate55_0);
						HMACSHA256 hmacsha = new HMACSHA256(Delegate619.smethod_0(Delegate618.smethod_0(Delegate618.delegate618_0), "@FlowBots#123!", Delegate619.delegate619_0));
						try
						{
							byte[] array = Delegate712.smethod_0(hmacsha, Delegate619.smethod_0(Delegate618.smethod_0(Delegate618.delegate618_0), text4, Delegate619.delegate619_0), Delegate712.delegate712_0);
							StringBuilder stringBuilder = new StringBuilder();
							for (int i = 0; i < array.Length; i++)
							{
								Delegate569.smethod_0(stringBuilder, Delegate713.smethod_0(ref array[i], "x2", Delegate713.delegate713_0), Delegate569.delegate569_0);
							}
							if (!Delegate104.smethod_0(text3, Delegate86.smethod_0(stringBuilder, Delegate86.delegate86_0), Delegate104.delegate104_0))
							{
								CommunicatorBroker.SsqChhQoYx = seed;
								try
								{
									string text5;
									Registry.GetInstance().RegKey("guid", CommunicatorBroker.SsqChhQoYx, out text5, false);
									goto IL_03E4;
								}
								catch
								{
									goto IL_03E4;
								}
								goto IL_03DE;
								IL_03E4:
								return num;
							}
							IL_03DE:
							throw new ActiveCheckException();
						}
						finally
						{
							if (hmacsha != null)
							{
								Delegate39.smethod_0(hmacsha, Delegate39.delegate39_0);
							}
						}
					}
					throw new ActiveCheckException(Delegate86.smethod_0(jobject["msg"], Delegate86.delegate86_0));
				}
				finally
				{
					if (dataStream != null)
					{
						Delegate39.smethod_0(dataStream, Delegate39.delegate39_0);
					}
				}
				IL_04DE:
				await taskAwaiter;
				TaskAwaiter<WebResponse> taskAwaiter4;
				taskAwaiter = taskAwaiter4;
				taskAwaiter4 = default(TaskAwaiter<WebResponse>);
				goto IL_017B;
			}
			catch (WebException ex)
			{
				Delegate34.smethod_0(Delegate50.smethod_0("Replikanto: Server {0}: Error validating Machine ID {1} on Replikanto server license: \"{2}\"", this.bool_0 ? 1 : 2, ReplikantoFramework.MachineIdSigned, Delegate31.smethod_0(ex, Delegate31.delegate31_0), Delegate50.delegate50_0), 3, Delegate34.delegate34_0);
				throw ex;
			}
			catch (Exception ex2)
			{
				Delegate34.smethod_0(Delegate50.smethod_0("Replikanto: Server {0}: Error validating Machine ID {1} on Replikanto server license: \"{2}\"", (!this.bool_0) ? 2 : 1, ReplikantoFramework.MachineIdSigned, Delegate31.smethod_0(ex2, Delegate31.delegate31_0), Delegate50.delegate50_0), 3, Delegate34.delegate34_0);
				throw ex2;
			}
			uint num2;
			return num2;
		}

		internal Task NotifyReplikantoDeactive()
		{
			CommunicatorBroker.<NotifyReplikantoDeactive>d__44 <NotifyReplikantoDeactive>d__;
			<NotifyReplikantoDeactive>d__.<>t__builder = Delegate425.smethod_0(Delegate425.delegate425_0);
			<NotifyReplikantoDeactive>d__.<>4__this = this;
			<NotifyReplikantoDeactive>d__.<>1__state = -1;
			<NotifyReplikantoDeactive>d__.<>t__builder.Start<CommunicatorBroker.<NotifyReplikantoDeactive>d__44>(ref <NotifyReplikantoDeactive>d__);
			return Delegate426.smethod_0(ref <NotifyReplikantoDeactive>d__.<>t__builder, Delegate426.delegate426_0);
		}

		private Task method_1(string string_7)
		{
			CommunicatorBroker.<Deactive>d__45 <Deactive>d__;
			<Deactive>d__.<>t__builder = Delegate425.smethod_0(Delegate425.delegate425_0);
			<Deactive>d__.apiURL = string_7;
			<Deactive>d__.<>1__state = -1;
			<Deactive>d__.<>t__builder.Start<CommunicatorBroker.<Deactive>d__45>(ref <Deactive>d__);
			return Delegate426.smethod_0(ref <Deactive>d__.<>t__builder, Delegate426.delegate426_0);
		}

		public async Task<JObject> SendMessageByHTTP(JObject msgObj)
		{
			string text = ((!this.bool_0) ? this.string_5 : this.string_4);
			try
			{
				WebRequest webRequest = Delegate701.smethod_0(Delegate33.smethod_0(text, "/onorderupdate", Delegate33.delegate33_0), Delegate701.delegate701_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "Machine-Id", ReplikantoFramework.MachineIdSigned, Delegate704.delegate704_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "x-api-key", CommunicatorBroker.string_0, Delegate704.delegate704_0);
				Delegate704.smethod_0(Delegate703.smethod_0(webRequest, Delegate703.delegate703_0), "Replikanto-Version", Delegate86.smethod_0(Delegate48.smethod_0(Delegate47.smethod_0(Delegate248.smethod_0(Delegate248.delegate248_0), Delegate47.delegate47_0), Delegate48.delegate48_0), Delegate86.delegate86_0), Delegate704.delegate704_0);
				Delegate706.smethod_0(webRequest, Delegate705.smethod_0(Delegate705.delegate705_0), Delegate706.delegate706_0);
				Delegate710.smethod_0(webRequest, "POST", Delegate710.delegate710_0);
				Delegate714.smethod_0(webRequest, "application/json", Delegate714.delegate714_0);
				Delegate702.smethod_0(webRequest, 20000, Delegate702.delegate702_0);
				byte[] array = Delegate619.smethod_0(Delegate618.smethod_0(Delegate618.delegate618_0), msgObj.ToString(Formatting.None, Array.Empty<JsonConverter>()), Delegate619.delegate619_0);
				Delegate715.smethod_0(webRequest, (long)array.Length, Delegate715.delegate715_0);
				Stream stream = Delegate716.smethod_0(webRequest, Delegate716.delegate716_0);
				Delegate717.smethod_0(stream, array, 0, array.Length, Delegate717.delegate717_0);
				Delegate718.smethod_0(stream, Delegate718.delegate718_0);
				TaskAwaiter<WebResponse> taskAwaiter = Delegate707.smethod_0(webRequest, Delegate707.delegate707_0).GetAwaiter();
				if (!taskAwaiter.IsCompleted)
				{
					goto IL_02DA;
				}
				IL_01B9:
				Stream stream2 = Delegate708.smethod_0(taskAwaiter.GetResult(), Delegate708.delegate708_0);
				try
				{
					JObject jobject = JObject.Parse(Delegate719.smethod_0(new StreamReader(stream2), Delegate719.delegate719_0));
					if (!jobject.ContainsKey("body"))
					{
						Action<JObject, LeaderOrderSource> action = this.action_0;
						if (action != null)
						{
							action(jobject, LeaderOrderSource.INTERNET_HTTP);
						}
					}
					else
					{
						object obj = JObject.Parse((string)jobject["body"]);
						Action<JObject, LeaderOrderSource> action2 = this.action_0;
						if (action2 != null)
						{
							if (CommunicatorBroker.<>o__46.callSite_0 == null)
							{
								CommunicatorBroker.<>o__46.callSite_0 = CallSite<Action<CallSite, Action<JObject, LeaderOrderSource>, object, LeaderOrderSource>>.Create(Delegate298.smethod_0(CSharpBinderFlags.ResultDiscarded, "Invoke", null, Delegate45.smethod_0(typeof(CommunicatorBroker).TypeHandle, Delegate45.delegate45_0), new CSharpArgumentInfo[]
								{
									Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType, null, Delegate297.delegate297_0),
									Delegate297.smethod_0(CSharpArgumentInfoFlags.None, null, Delegate297.delegate297_0),
									Delegate297.smethod_0(CSharpArgumentInfoFlags.UseCompileTimeType | CSharpArgumentInfoFlags.Constant, null, Delegate297.delegate297_0)
								}, Delegate298.delegate298_0));
							}
							CommunicatorBroker.<>o__46.callSite_0.Target(CommunicatorBroker.<>o__46.callSite_0, action2, obj, LeaderOrderSource.INTERNET_HTTP);
						}
					}
					return jobject;
				}
				finally
				{
					if (stream2 != null)
					{
						Delegate39.smethod_0(stream2, Delegate39.delegate39_0);
					}
				}
				IL_02DA:
				await taskAwaiter;
				TaskAwaiter<WebResponse> taskAwaiter2;
				taskAwaiter = taskAwaiter2;
				taskAwaiter2 = default(TaskAwaiter<WebResponse>);
				goto IL_01B9;
			}
			catch (WebException ex)
			{
				Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Error sending order update: \"", Delegate31.smethod_0(ex, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
				throw ex;
			}
			catch (Exception ex2)
			{
				Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Error sending order update: \"", Delegate31.smethod_0(ex2, Delegate31.delegate31_0), "\"", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
				throw ex2;
			}
			JObject jobject2;
			return jobject2;
		}

		public override string ToString()
		{
			return Delegate32.smethod_0("CommunicatorBroker IsWSRunning {0}", this.Boolean_0, Delegate32.delegate32_0);
		}

		[Conditional("Debug")]
		private void method_2(string string_7)
		{
			Delegate83.smethod_0(Delegate82.smethod_0("Communicator - {0:yyyy-MM-dd HH.mm.ss} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), string_7, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
		}

		[CompilerGenerated]
		private void method_3(ReconnectionInfo reconnectionInfo_0)
		{
			if (reconnectionInfo_0.Type == ReconnectionType.Initial)
			{
				this.bool_1 = false;
				Delegate34.smethod_0("Replikanto: Communicator connected", 1, Delegate34.delegate34_0);
			}
			else
			{
				Delegate34.smethod_0("Replikanto: Communicator connected successfully", 1, Delegate34.delegate34_0);
			}
			Action action = this.action_2;
			if (action != null)
			{
				action();
			}
			this.websocketClient_0.ErrorReconnectTimeout = new TimeSpan?(Delegate436.smethod_0(1000.0, Delegate436.delegate436_0));
			this.uint_0 = 0U;
		}

		[CompilerGenerated]
		private void method_4(DisconnectionInfo disconnectionInfo_0)
		{
			DisconnectionType type = disconnectionInfo_0.Type;
			if (type == DisconnectionType.Lost || type == DisconnectionType.ByServer || type == DisconnectionType.ByUser || type == DisconnectionType.Exit || type == DisconnectionType.NoMessageReceived)
			{
				if (type == DisconnectionType.Lost)
				{
					Delegate34.smethod_0("Replikanto: Communicator reconnecting...", 1, Delegate34.delegate34_0);
				}
				Action<DisconnectionType> action = this.action_4;
				if (action != null)
				{
					action(type);
				}
			}
			if (this.uint_0 == 0U && type == DisconnectionType.Error)
			{
				Action<string> action2 = this.action_1;
				if (action2 != null)
				{
					action2(Delegate32.smethod_0("Replikanto communicator is offline, it will try to reconnect ({0})", type, Delegate32.delegate32_0));
				}
			}
			else if (this.uint_0 > 0U && type == DisconnectionType.Error)
			{
				Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: Communicator is trying to reconnect. Attempt {0}", this.uint_0, Delegate32.delegate32_0), 1, Delegate34.delegate34_0);
			}
			if (this.websocketClient_0.IsReconnectionEnabled)
			{
				Action action3 = this.action_3;
				if (action3 != null)
				{
					action3();
				}
			}
			if (this.uint_0 <= 5U)
			{
				WebsocketClient websocketClient = this.websocketClient_0;
				TimeSpan? timeSpan = this.websocketClient_0.ErrorReconnectTimeout;
				long? num;
				if (timeSpan == null)
				{
					num = null;
				}
				else
				{
					TimeSpan valueOrDefault = timeSpan.GetValueOrDefault();
					num = new long?(Delegate593.smethod_0(ref valueOrDefault, Delegate593.delegate593_0) * 2L);
				}
				long? num2 = num;
				websocketClient.ErrorReconnectTimeout = new TimeSpan?(Delegate594.smethod_0(num2.Value, Delegate594.delegate594_0));
			}
			if (this.uint_0 >= 100U)
			{
				WebsocketClient websocketClient2 = this.websocketClient_0;
				TimeSpan? timeSpan = null;
				websocketClient2.ErrorReconnectTimeout = timeSpan;
				Action<DisconnectionType> action4 = this.action_4;
				if (action4 != null)
				{
					action4(type);
				}
				Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: Communicator was unable to connect after {0} attempts. Please restart Ninjatrader", this.uint_0, Delegate32.delegate32_0), 3, Delegate34.delegate34_0);
			}
			this.uint_0 += 1U;
		}

		[CompilerGenerated]
		private void method_5(ResponseMessage responseMessage_0)
		{
			try
			{
				if (responseMessage_0.MessageType == WebSocketMessageType.Text)
				{
					try
					{
						JObject jobject = JsonConvert.DeserializeObject<JObject>(responseMessage_0.Text);
						try
						{
							if (jobject.ContainsKey("msg_id"))
							{
								(int)jobject["msg_id"];
							}
						}
						catch (Exception)
						{
						}
						Action<JObject, LeaderOrderSource> action = this.action_0;
						if (action != null)
						{
							action(jobject, LeaderOrderSource.INTERNET_WS);
						}
						goto IL_00C5;
					}
					catch (JsonReaderException ex)
					{
						Action<string> action2 = this.action_1;
						if (action2 != null)
						{
							action2(Delegate31.smethod_0(ex, Delegate31.delegate31_0));
						}
						goto IL_00C5;
					}
					catch (Exception ex2)
					{
						Action<string> action3 = this.action_1;
						if (action3 != null)
						{
							action3(Delegate31.smethod_0(ex2, Delegate31.delegate31_0));
						}
						goto IL_00C5;
					}
				}
				Action<string> action4 = this.action_1;
				if (action4 != null)
				{
					action4(Delegate32.smethod_0("Replikanto communicator ({0}) != Text", responseMessage_0.MessageType, Delegate32.delegate32_0));
				}
				IL_00C5:;
			}
			catch (Exception ex3)
			{
				Delegate34.smethod_0(Delegate33.smethod_0("Replikanto: Error when receiving the message from FlowBots servers. ", Delegate31.smethod_0(ex3, Delegate31.delegate31_0), Delegate33.delegate33_0), 3, Delegate34.delegate34_0);
			}
		}

		internal static void smethod_1()
		{
		}

		internal static object smethod_2(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static object smethod_3()
		{
			return Registry.GetInstance();
		}

		internal static bool smethod_4(object object_0)
		{
			return object_0.IsRunning;
		}

		internal static void smethod_5(object object_0)
		{
			object_0.Dispose();
		}

		internal static void smethod_6()
		{
		}

		internal static ReconnectionType smethod_7(object object_0)
		{
			return object_0.Type;
		}

		internal static DisconnectionType smethod_8(object object_0)
		{
			return object_0.Type;
		}

		internal static bool smethod_9(object object_0)
		{
			return object_0.IsReconnectionEnabled;
		}

		internal static void smethod_10(object object_0)
		{
			object_0();
		}

		internal static WebSocketMessageType smethod_11(object object_0)
		{
			return object_0.MessageType;
		}

		internal static object smethod_12(object object_0)
		{
			return object_0.Text;
		}

		internal static object smethod_13(object object_0, object object_1)
		{
			return object_0[object_1];
		}

		internal static int smethod_14(object object_0)
		{
			return (int)object_0;
		}

		private static readonly string string_0 = "i3NGSt6VzI6F9G2yfXly326y2aOiHalBNAqE4Qtc";

		private static readonly string string_1 = "wss://wss.replikanto.com";

		private static readonly string string_2 = "https://api.replikanto.com";

		private static readonly string string_3 = "https://jol6nau3w0.execute-api.eu-west-2.amazonaws.com/production";

		private string string_4 = CommunicatorBroker.string_2;

		private string string_5 = CommunicatorBroker.string_3;

		private bool bool_0 = true;

		private string string_6 = CommunicatorBroker.string_1;

		private static string SsqChhQoYx = string.Empty;

		private static long long_0 = 0L;

		private IPAddress ipaddress_0;

		private WebsocketClient websocketClient_0;

		private static SemaphoreSlim semaphoreSlim_0 = new SemaphoreSlim(1, 1);

		[CompilerGenerated]
		private Action<JObject, LeaderOrderSource> action_0;

		[CompilerGenerated]
		private Action<string> action_1;

		[CompilerGenerated]
		private Action action_2;

		[CompilerGenerated]
		private Action action_3;

		[CompilerGenerated]
		private Action<DisconnectionType> action_4;

		private uint uint_0;

		private bool bool_1;
	}
}
