﻿using System;
using System.Net.Mail;

namespace Robot.Service
{
    class MyEmail
    {

        private SmtpClient mySmtpClient;
        private bool UseaASYNC;

        public MyEmail()
        {
            UseaASYNC = true;
        }


        /// <summary>
        ///  Создание Smtp-клиента
        /// </summary>
        /// <param name="From"></param>
        /// <param name="To"></param>
        /// <param name="myMessgeHeader"></param>
        /// <param name="myMessgeBody"></param>
        private void CreateClient()
        {

            var mySmtp = new SmtpClient();
            mySmtp.Host = "smtp.yandex.com"; //"smtp.gmail.com";
            mySmtp.TargetName = "SMTPSVC/" + mySmtp.Host;
            mySmtp.Port = 465; // 587;
            var User = "daschkevich.denis";
            var Pass = "my1dd2pass";
            mySmtp.UseDefaultCredentials = false;
            mySmtp.EnableSsl = false;
            mySmtp.Credentials = new System.Net.NetworkCredential(User, Pass);
            mySmtpClient = mySmtp;
        }
            
        
        /// <summary>
        ///  Основная функция отправки по е-майл
        /// </summary>
        /// <param name="From"></param>
        /// <param name="To"></param>
        /// <param name="myMessgeHeader"></param>
        /// <param name="myMessgeBody"></param>
        public void SendMail(string From,string To, string myMessgeHeader, string myMessgeBody)
        {

            if (myMessgeHeader==null) myMessgeHeader = "ROBOT: health report, " + DateTime.Now.ToString();

            var myMail = new MailMessage(From, To, myMessgeHeader, myMessgeBody);

            if (mySmtpClient == null) CreateClient();

            try
            {
                if (UseaASYNC)
                {
                    mySmtpClient.SendMailAsync(myMail);
                }
                else
                {
                    mySmtpClient.Send(myMail);
                }
            }
            catch (SmtpFailedRecipientsException ex)
            {
                for (int i = 0; i < ex.InnerExceptions.Length; i++)
                {
                    SmtpStatusCode status = ex.InnerExceptions[i].StatusCode;
                    if (status == SmtpStatusCode.MailboxBusy ||
                        status == SmtpStatusCode.MailboxUnavailable)
                    {
                        Console.WriteLine("Delivery failed - retrying in 5 seconds.");
                        System.Threading.Thread.Sleep(500);
                        mySmtpClient.Send(myMail);
                    }
                    else
                    {
                        Console.WriteLine("Failed to deliver message to {0}",
                                          ex.InnerExceptions[i].FailedRecipient);
                    }
                }
            }


        }

        public void Test_email()
        {
            var From = "daschkevich.denis@ya.ru"; // "myfinnews@gmail.com";
            var To = "lebedev.srg@ya.ru";  //"lebedev.srg@outlook.com"; // 
            SendMail(From, To, "Test mail from Robot: Header", "Test mail from Robot: Body test");
        }

    }
}
